<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 

// 이미지 없음 - 공통적용
$no_img = THEMA_URL.'/assets/img/no-img.jpg';

if($at_set['thema'] != THEMA) { // 테마 설치 또는 변경시 초기값
	unset($at_set);
	$at_set['body_bgcolor'] = '#333333';
	$at_set['main'] = 13;
	$at_set['page'] = 9;
}

//Setup Column
if($is_main) {
	$col_content = ($at_set['main']) ? $at_set['main'] : 13;
} else {
	$col_content = ($at_set['page']) ? $at_set['page'] : 9;
}

$col_content = (int)$col_content;

$container = '';
if($col_content == 13) { // Full Wide
	$col_name = '';
	$container = 'container';
} else if($col_content == 12) { // One Column
	$col_name = 'one';
} else { // Two Column
	$col_name = 'two';
	$col_side = 12 - $col_content;
}

$at_set['background'] = ($at_set['background']) ? $at_set['background'] : 'none';

//Stylesheet
add_stylesheet('<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Roboto:400,300,500,500italic,700,900,400italic,700italic">',0);
add_stylesheet('<link rel="stylesheet" href="'.THEMA_URL.'/assets/bs3/css/bootstrap.min.css" type="text/css" media="screen">',0);
add_stylesheet('<link rel="stylesheet" href="'.COLORSET_URL.'/colorset.css" type="text/css" media="screen" class="thema-colorset">',0);
add_stylesheet('<link rel="stylesheet" href="'.THEMA_URL.'/widget/widget.css" type="text/css" media="screen">',0);
?>
<style> 
	body { background-color: <?php echo $at_set['body_bgcolor'];?>; background-image: <?php echo ($at_set['body_background'] && $at_set['body_background'] != 'none') ? "url('".$at_set['body_background']."')" : "none";?>; }
</style>
<div class="wrapper <?php echo $at_set['layout'];?> <?php echo $at_set['font'];?><?php echo (G5_IS_MOBILE) ? ' font-14' : ''; //Mobile 14px?>">

	<!-- Hidden Sidebar -->
	<aside id="asideMenu" class="at-sidebar sidebar">
		<?php thema_widget('', 'widget.sidebar.php');?>
	</aside>

	<!-- LNB -->
	<aside>
		<div class="<?php echo $at_set['lnb'];?> at-lnb">
			<div class="container">
				<?php thema_widget('', 'widget.lnb.php');?>
			</div>
		</div>
	</aside>

	<header>
		<div class="navbar <?php echo $at_set['menu'];?> at-navbar en" role="navigation">
			<div class="container">
				<div class="navbar-header">

					<!-- Logo -->
					<a class="navbar-logo" href="<?php echo $at_href['home'];?>">
						<b>AMINA</b>
						<span class="hidden-xs">세상을 바꾸는 작은 힘 - 아미나</span>
					</a>

					<div class="navbar-btn btn-group pull-right">
						<button type="button" class="btn btn-default btn-xs" data-toggle="collapse" data-target=".navbar-collapse">
							<i class="fa fa-bars fa-2x"></i>
						</button>
						<?php if(IS_YC) { // 영카트 이용시 ?>
							<?php if(IS_SHOP) { // 쇼핑몰일 때 ?>
								<a href="<?php echo G5_URL;?>" role="button" class="btn btn-default btn-xs">
									<span class="blue"><i class="fa fa-coffee fa-2x"></i></span>
								</a>
							<?php } else { // 커뮤니티일 때 ?>
								<a href="<?php echo G5_SHOP_URL;?>" role="button" class="btn btn-default btn-xs">
									<span class="red"><i class="fa fa-shopping-cart fa-2x"></i></span>
								</a>
							<?php } ?>
						<?php } ?>			
						<button type="button" class="btn btn-default btn-xs navbar-toggle-asideMenu asideButton">
							<i class="fa fa-outdent fa-2x"></i>
						</button>
					</div>
					<div class="clearfix"></div>
				</div>

				<!-- Menu -->
				<div class="navbar-collapse collapse">
					<ul class="nav navbar-nav navbar-right">
						<li<?php echo ($is_main && !$gid) ? ' class="active"' : '';?>>
							<a href="<?php echo $at_href['home'];?>">메인</a>
						</li>
						<?php for ($i=1; $i < count($menu); $i++) { //메뉴출력 - 1번부터 출력?>
							<?php if($menu[$i]['is_sub']) { //서브메뉴가 있을 때 ?>
								<li class="dropdown<?php echo ($menu[$i]['on'] == "on") ? ' active' : '';?>">
									<a href="<?php echo $menu[$i]['href'];?>" class="dropdown-toggle" <?php echo(G5_IS_MOBILE) ? 'data-toggle="dropdown"' : 'data-hover="dropdown"';?> data-close-others="true"<?php echo $menu[$i]['target'];?>>
										<?php echo $menu[$i]['name'];?><i class="fa fa-circle <?php echo $menu[$i]['new'];?>"></i>
									</a>
									<ul class="dropdown-menu">
									<?php for($j=0; $j < count($menu[$i]['sub']); $j++) { ?>
										<?php if(!G5_IS_MOBILE && $menu[$i]['sub'][$j]['is_sub']) { //서브메뉴가 있을 때 ?>
											<li class="dropdown-submenu<?php echo ($menu[$i]['sub'][$j]['on'] == "on") ? ' sub-on' : '';?>">
												<a tabindex="-1" href="<?php echo $menu[$i]['sub'][$j]['href'];?>"<?php echo $menu[$i]['sub'][$j]['target'];?>>
													<?php echo $menu[$i]['sub'][$j]['name'];?><i class="fa fa-circle sub-<?php echo $menu[$i]['sub'][$j]['new'];?>"></i>
												</a>
												<ul class="dropdown-menu dropdown-menu-sub">
												<?php for($k=0; $k < count($menu[$i]['sub'][$j]['sub']); $k++) { ?>
													<li<?php echo ($menu[$i]['sub'][$j]['sub'][$k]['on'] == "on") ? ' class="sub-on"' : '';?>>
														<a tabindex="-1" href="<?php echo $menu[$i]['sub'][$j]['sub'][$k]['href'];?>"<?php echo $menu[$i]['sub'][$j]['sub'][$k]['target'];?>><?php echo $menu[$i]['sub'][$j]['sub'][$k]['name'];?></a>
													</li>
												<?php } ?>
												</ul>
											</li>
										<?php } else { //서브메뉴가 없을 때 ?>
											<li<?php echo ($menu[$i]['sub'][$j]['on'] == "on") ? ' class="sub-on"' : '';?>>
												<a href="<?php echo $menu[$i]['sub'][$j]['href'];?>"<?php echo $menu[$i]['sub'][$j]['target'];?>>
													<?php echo $menu[$i]['sub'][$j]['name'];?><i class="fa fa-circle <?php echo $menu[$i]['sub'][$j]['new'];?>"></i>
												</a>
											</li>
										<?php } ?>
									<?php } ?>
									</ul>
								</li>
							<?php } else { //서브메뉴가 없을 때 ?>
								<li<?php echo ($menu[$i]['on'] == "on") ? ' class="active"' : '';?>>
									<a href="<?php echo $menu[$i]['href'];?>"<?php echo $menu[$i]['target'];?>>
										<?php echo $menu[$i]['name'];?><i class="fa fa-circle <?php echo $menu[$i]['new'];?>"></i>
									</a>
								</li>
							<?php } ?>
						<?php } //자동메뉴 ?>
						<?php if(IS_YC) { // 영카트 이용시 ?>
							<?php if(IS_SHOP) { // 쇼핑몰일 때 ?>
								<li class="hidden-xs at-tip" data-original-title="<nobr>커뮤니티로 이동</nobr>" data-toggle="tooltip" data-placement="bottom" data-html="true">
									<a href="<?php echo G5_URL;?>">
										<i class="fa fa-coffee fa-lg blue"></i>
									</a>
								</li>
							<?php } else { // 커뮤니티일 때 ?>
								<li class="hidden-xs at-tip" data-original-title="<nobr>쇼핑몰로 이동</nobr>" data-toggle="tooltip" data-placement="bottom" data-html="true">
									<a href="<?php echo G5_SHOP_URL;?>">
										<i class="fa fa-shopping-cart fa-lg red"></i>
									</a>
								</li>
							<?php } ?>
						<?php } ?>	
						<li class="hidden-xs at-tip asideButton" data-original-title="<nobr>Open Sidebar</nobr>" data-toggle="tooltip" data-placement="bottom" data-html="true">
							<a href="#" class="dropdown-toggle dropdown-form-toggle">
								<i class="fa fa-outdent fa-lg"></i>
							</a>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</header>

	<?php // Title
		if($is_main) { // Main Title 
			thema_widget('title', 'widget.title.main.php', 'effect=slide interval=5000'); // Main Title
		} else {
			if($page_title) { //Page Title
				thema_widget('title', 'widget.title.page.php');
			}
		} 
	?>		

	<div class="at-content">
		<?php if($col_name) { ?>
			<div class="container">
			<?php if($col_name == "two") { ?>
				<div class="row">
					<div class="col-md-<?php echo $col_content;?><?php echo ($at_set['side']) ? ' pull-right' : '';?> contentArea">		
			<?php } ?>
		<?php } ?>

